/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.player;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.api.handler.data.IQuest;
import noppes.npcs.client.CustomNpcResourceListener;
import noppes.npcs.client.TextBlockClient;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.GuiNpcButton;
import noppes.npcs.client.gui.util.GuiNpcLabel;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import noppes.npcs.client.gui.util.ITopButtonListener;
import noppes.npcs.constants.EnumPlayerPacket;
import noppes.npcs.constants.EnumRewardType;
import noppes.npcs.controllers.data.Quest;

public class GuiQuestCompletion
extends GuiNPCInterface
implements ITopButtonListener {
    private static final ResourceLocation bookGuiTextures = new ResourceLocation("textures/gui/book.png");
    private final IQuest quest;
    private final ResourceLocation resource = new ResourceLocation("customnpcs", "textures/gui/smallbg.png");
    int maxLine;
    int currentPage = 0;
    int hover;
    TextBlockClient textBlockClient;

    public GuiQuestCompletion(IQuest iQuest) {
        this.xSize = 176;
        this.ySize = 222;
        this.quest = iQuest;
        this.drawDefaultBackground = false;
        this.title = "";
    }

    @Override
    public void buttonEvent(IGuiNpcButton button) {
        if (button.getID() == 0) {
            this.close();
        }
    }

    private void drawQuestText() {
        int i = this.currentPage * this.maxLine;
        for (int j = 0; j < this.maxLine && i < this.textBlockClient.lines.size(); ++i, ++j) {
            String text = ((ITextComponent)this.textBlockClient.lines.get(i)).func_150254_d();
            this.field_146289_q.func_78276_b(text, this.guiLeft + 4, this.guiTop + 16 + j * this.field_146289_q.field_78288_b, CustomNpcResourceListener.DefaultTextColor);
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.resource);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, this.xSize, this.ySize);
        this.func_73730_a(this.guiLeft + 4, this.guiLeft + 170, this.guiTop + 13, -16777216 + CustomNpcResourceListener.DefaultTextColor);
        this.drawQuestText();
        this.hover = -1;
        if (this.textBlockClient.lines.size() * this.field_146289_q.field_78288_b > this.maxLine) {
            String page = this.currentPage + 1 + "/" + (int)Math.ceil((double)this.textBlockClient.lines.size() / (double)this.maxLine);
            this.field_146289_q.func_78276_b(page, this.guiLeft + 150 - this.field_146289_q.func_78256_a(page), this.guiTop + this.ySize - 20, CustomNpcResourceListener.DefaultTextColor);
            if (this.currentPage > 0) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(this.guiLeft + 6), (float)(this.guiTop + this.ySize - 20), (float)0.0f);
                if (this.isMouseHover(mouseX, mouseY, this.guiLeft + 6, this.guiTop + this.ySize - 20, 18, 10)) {
                    this.hover = 0;
                }
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, this.hover == 0 ? 26 : 3, 207, 18, 10);
                GlStateManager.func_179121_F();
            }
            if ((this.currentPage + 1) * this.maxLine < this.textBlockClient.lines.size()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(this.guiLeft + this.xSize - 24), (float)(this.guiTop + this.ySize - 20), (float)0.0f);
                if (this.isMouseHover(mouseX, mouseY, this.guiLeft + this.xSize - 24, this.guiTop + this.ySize - 20, 18, 10)) {
                    this.hover = 1;
                }
                this.field_146297_k.func_110434_K().func_110577_a(bookGuiTextures);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_73729_b(0, 0, this.hover == 1 ? 26 : 3, 194, 18, 10);
                GlStateManager.func_179121_F();
            }
        }
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        String questTitle = new TextComponentTranslation("questlog.completed", new Object[0]).func_150254_d() + new TextComponentTranslation(this.quest.getName(), new Object[0]).func_150254_d();
        int left = (this.xSize - this.field_146289_q.func_78256_a(questTitle)) / 2;
        this.addLabel(new GuiNpcLabel(0, questTitle, this.guiLeft + left, this.guiTop + 4));
        this.textBlockClient = new TextBlockClient(this.quest.getCompleteText(), 170, true, (Entity)this.npc, this.player);
        this.maxLine = 180 / this.field_146289_q.field_78288_b;
        GuiNpcButton button = this.textBlockClient.lines.size() > this.maxLine ? new GuiNpcButton(0, this.guiLeft + 28, this.guiTop + this.ySize - 24, 80, 20, new TextComponentTranslation("quest.complete", new Object[0]).func_150254_d()) : new GuiNpcButton(0, this.guiLeft + 48, this.guiTop + this.ySize - 24, 80, 20, new TextComponentTranslation("quest.complete", new Object[0]).func_150254_d());
        this.addButton(button);
    }

    @Override
    public void func_73869_a(char c, int i) {
        if (i == 1 || this.isInventoryKey(i)) {
            this.close();
        }
    }

    @Override
    public void save() {
        if (((Quest)this.quest).rewardType == EnumRewardType.ONE_SELECT) {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.QuestChooseReward, this.quest.getId());
        } else {
            NoppesUtilPlayer.sendData(EnumPlayerPacket.QuestCompletion, this.quest.getId());
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseBottom) {
        if (this.hover != -1) {
            this.currentPage = this.hover == 1 ? ++this.currentPage : --this.currentPage;
            return;
        }
        super.func_73864_a(mouseX, mouseY, mouseBottom);
    }
}

